/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CustomListCellRenderer;
import cds.aladin.DynamicTapForm;
import cds.aladin.FilterActionClass;
import cds.aladin.ForeignKeyColumn;
import cds.aladin.JoinConstraint;
import cds.aladin.Server;
import cds.aladin.ServerTap;
import cds.aladin.TapForeignKeysRenderer;
import cds.aladin.TapManager;
import cds.aladin.TapTable;
import cds.aladin.TapTableColumn;
import cds.aladin.UploadTablesRenderer;
import cds.tools.CDSConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class JoinFacade
extends JPanel
implements FilterActionClass,
ActionListener,
ItemListener {
    private static final long serialVersionUID = 797757395359447128L;
    public Aladin aladin;
    public ServerTap serverTap;
    public JComboBox serverTablesGui;
    public List<JoinConstraint> constraints;
    public Vector<TapTableColumn> mainColumns1;
    public String mainRaColumnName;
    public String mainDecColumnName;
    JPanel constraintListPanel;
    GridBagConstraints cc = new GridBagConstraints();
    private JRadioButton radio1;
    private JRadioButton radio2;
    private JComboBox uploadTablesGui;
    private JRadioButton positionJoin;
    private JRadioButton foreignRelJoin;
    private JTextField radius;
    private JComboBox targetRefCols;
    private JComboBox targetCols;
    private JComboBox unrelJoinOperators;
    private JComboBox refCols;
    private JLabel info1 = new JLabel();
    private String joinTableName;
    private JRadioButton otherJoin;
    private String CLIENTINSTR;
    public String mainTable;
    private JCheckBox addOrReplace;
    private JCheckBox noTypeFilter;
    public static String JOINCONTRAINTSTIP;
    public static String JOINCONSTRAINTASKRADIUS;
    public static String JOINCONSTRAINTASKRADIUSTIP;
    public static String JOINCONSTRAINTASKCOL;
    public static String JOINCONSTRAINTASKCOLTIP;
    public static String JOINCONSTRAINTASKEQCOLTIP;
    public static String GENERCIERROR_JOIN;
    public static String ERROR_NOJOINCOLUMNS;
    public static String ERROR_NOJOINRADUIS;
    public static String JOINFRAMETITLE;
    public static String ERROR_NOINTERFACEMESSAGE;
    public static String LOADING_JOININTERFACEMESSAGE;
    public static String JOINUPLOADEDTABLETIP;
    public static String JOINTABLELABEL;
    public static String ERROR_NOJOINCOLUMN;
    public static String UPLOADJOINTABLENAMETOOLTIP;
    public static String WRITEJOINBUTTONLABEL;
    public static String JOINUPLOADTABLELABEL;
    public static String JOINCONSTRAINTADDEDNOTIFICATION;
    public static String JOINTIP;
    public static String JOINADDORREPLACELABEL;
    public static String JOINADDORREPLACETOOLTIP;
    public static String JOINCOLFILTERLABEL;
    public static String JOINCOLFILTERTOOLTIP;
    protected static final String[] joinOperators;

    public JoinFacade() {
        this.constraints = new ArrayList<JoinConstraint>();
    }

    public JoinFacade(Aladin aladin, ServerTap server) {
        this();
        this.aladin = aladin;
        this.serverTap = server;
        this.showloading();
        TapManager.getInstance(aladin).initUploadFrame();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(900, 700);
    }

    public void setJoinTableForm(String priTableChoice, String secTableChoice) {
        if (this.mainTable != this.serverTap.selectedTableName) {
            this.mainTable = this.serverTap.selectedTableName;
            Vector<String> tables = this.serverTap.getTableNames();
            TapTable chosenTable = null;
            chosenTable = priTableChoice == null || !tables.contains(priTableChoice) ? this.serverTap.getSuitableJoinTable() : this.serverTap.tapClient.tablesMetaData.get(priTableChoice);
            String selectedTableName = chosenTable.getTable_name();
            TapTable mainTableMeta = this.serverTap.tapClient.tablesMetaData.get(this.mainTable);
            Vector<TapTableColumn> mainColumns = mainTableMeta.getColumns();
            Vector<TapTableColumn> joinColumns = this.serverTap.getColumnsToLoad(selectedTableName, this.serverTap.tapClient.tablesMetaData);
            TapTable serverJoinTable = this.serverTap.tapClient.tablesMetaData.get(selectedTableName);
            Map<String, TapTable> uploadMeta = this.serverTap.tapClient.tapManager.getUploadedTables();
            TapTable chosenTable2 = null;
            String secondaryTable = null;
            if (this.serverTap.tapClient.isUploadAllowed() && uploadMeta != null && !uploadMeta.isEmpty()) {
                secondaryTable = secTableChoice == null || !uploadMeta.containsKey(secTableChoice) ? (uploadMeta.size() > 1 ? uploadMeta.keySet().iterator().next() : null) : secTableChoice;
            }
            if (secondaryTable != null) {
                chosenTable2 = uploadMeta.get(secondaryTable);
            }
            this.removeAll();
            this.setLayout(new GridBagLayout());
            this.CLIENTINSTR = Aladin.chaine.getString("TAPJOININSTR");
            JPanel toppanel = new JPanel(new FlowLayout(0));
            JButton joinInfo = null;
            Image image = Aladin.aladin.getImagette("info1.png");
            joinInfo = image == null ? new JButton("Info") : new JButton(new ImageIcon(image));
            joinInfo.setMargin(new Insets(0, 0, 0, 0));
            joinInfo.setBorderPainted(false);
            joinInfo.setContentAreaFilled(false);
            joinInfo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JoinFacade.showStatusReport();
                }
            });
            toppanel.add(joinInfo);
            this.info1 = new JLabel(this.CLIENTINSTR);
            toppanel.add(this.info1);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weighty = 0.01;
            c.weightx = 0.1;
            c.anchor = 18;
            c.fill = 0;
            c.insets = new Insets(0, 0, 0, 0);
            this.add((Component)toppanel, c);
            JPanel tablesPanel = null;
            try {
                Vector<String> model = new Vector<String>();
                model.addAll(tables);
                this.serverTablesGui = new JComboBox(model);
                ArrayList<JComponent> compToPrefix = new ArrayList<JComponent>();
                ButtonGroup radioGroup1 = new ButtonGroup();
                this.radio1 = new JRadioButton();
                this.radio1.setSelected(true);
                this.radio1.addActionListener(this);
                this.radio1.setActionCommand("SERVERJOINTABLESELECTED");
                radioGroup1.add(this.radio1);
                compToPrefix.add(this.radio1);
                tablesPanel = DynamicTapForm.getTablesPanel(null, this, JOINTABLELABEL, this.serverTablesGui, chosenTable, tables, compToPrefix, true);
                tablesPanel.setFont(CDSConstants.BOLD);
                JButton tapMeta = null;
                image = Aladin.aladin.getImagette("Help.png");
                tapMeta = image == null ? new JButton("Meta") : new JButton(new ImageIcon(image));
                tapMeta.setMargin(new Insets(0, 0, 0, 0));
                tapMeta.setBorderPainted(false);
                tapMeta.setContentAreaFilled(false);
                tapMeta.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JoinFacade.this.serverTap.showStatusReport(false);
                    }
                });
                tablesPanel.add(tapMeta);
                c.weighty = 0.01;
                c.weightx = 0.1;
                c.anchor = 18;
                c.fill = 0;
                c.insets = new Insets(0, 4, 0, 4);
                ++c.gridy;
                this.add((Component)tablesPanel, c);
                this.joinTableName = chosenTable.getTable_name();
                if (this.serverTap.tapClient.isUploadAllowed()) {
                    MutableComboBoxModel uploadModel = (MutableComboBoxModel)this.serverTap.tapClient.tapManager.getUploadClientModel();
                    this.radio2 = new JRadioButton();
                    radioGroup1.add(this.radio2);
                    this.radio2.setToolTipText(JOINUPLOADEDTABLETIP);
                    this.radio2.setEnabled(uploadModel.getSize() > 0);
                    this.radio2.addActionListener(this);
                    this.radio2.setActionCommand("UPLOADJOINTABLESELECTED");
                    this.uploadTablesGui = new JComboBox();
                    this.uploadTablesGui.setModel(uploadModel);
                    compToPrefix = new ArrayList();
                    compToPrefix.add(this.radio2);
                    tablesPanel = DynamicTapForm.getTablesPanel(null, this, JOINUPLOADTABLELABEL, this.uploadTablesGui, chosenTable2, null, compToPrefix, false);
                    UploadTablesRenderer uploadTableRenderer = UploadTablesRenderer.getInstance(this.aladin);
                    this.uploadTablesGui.setRenderer(uploadTableRenderer);
                    if (this.uploadTablesGui.getSelectedItem() != null) {
                        String uploadTable = (String)this.uploadTablesGui.getSelectedItem();
                        String planeName = uploadTableRenderer.getUploadPlaneName(uploadTable);
                        this.uploadTablesGui.setToolTipText(UploadTablesRenderer.getToolTip(planeName, uploadTable));
                    }
                    tablesPanel.setFont(CDSConstants.BOLD);
                    c.weightx = 0.12;
                    c.anchor = 18;
                    c.fill = 0;
                    c.insets = new Insets(0, 4, 0, 4);
                    ++c.gridy;
                    this.add((Component)tablesPanel, c);
                    c.weighty = 0.05;
                }
            }
            catch (BadLocationException e) {
                Aladin.error(this, e.getMessage());
                Aladin.trace(3, e.getMessage());
                return;
            }
            JPanel joinConstraintsPanel = new JPanel();
            joinConstraintsPanel.setBackground(Aladin.COLOR_CONTROL_BACKGROUND);
            joinConstraintsPanel.setLayout(new BoxLayout(joinConstraintsPanel, 1));
            joinConstraintsPanel.setBorder(BorderFactory.createTitledBorder(JOINCONTRAINTSTIP));
            ButtonGroup radioGroup2 = new ButtonGroup();
            JRadioButton gui = new JRadioButton();
            gui.setLayout(new GridBagLayout());
            GridBagConstraints guic = new GridBagConstraints();
            guic.anchor = 17;
            guic.fill = 2;
            guic.insets = new Insets(2, 25, 2, 0);
            guic.gridx = 0;
            guic.gridy = 0;
            guic.weightx = 0.01;
            guic.weighty = 1.0;
            gui.add((Component)new JLabel(JOINCONSTRAINTASKCOL), guic);
            this.foreignRelJoin = gui;
            radioGroup2.add(gui);
            ++guic.gridx;
            guic.insets = new Insets(2, 5, 2, 0);
            guic.weightx = 0.99;
            Vector<ForeignKeyColumn> joinConditions = this.getJoinRefConditions(mainTableMeta);
            this.targetRefCols = new JComboBox<ForeignKeyColumn>(joinConditions);
            this.targetRefCols.setRenderer(new TapForeignKeysRenderer());
            gui.add((Component)this.targetRefCols, guic);
            gui.setToolTipText(JOINCONSTRAINTASKEQCOLTIP);
            joinConstraintsPanel.add(gui);
            gui = new JRadioButton();
            gui.setLayout(new GridBagLayout());
            guic = new GridBagConstraints();
            guic.insets = new Insets(0, 25, 0, 0);
            guic.gridx = 0;
            guic.gridy = 0;
            guic.anchor = 17;
            guic.fill = 2;
            guic.weightx = 0.01;
            guic.weighty = 1.0;
            gui.add((Component)new JLabel(JOINCONSTRAINTASKRADIUS), guic);
            ++guic.gridx;
            guic.weightx = 0.99;
            guic.insets = new Insets(0, 5, 0, 0);
            this.radius = new JTextField(30);
            this.radius.setToolTipText(this.serverTap.RADIUS_EX);
            gui.add((Component)this.radius, guic);
            joinConstraintsPanel.add(gui);
            this.positionJoin = gui;
            radioGroup2.add(gui);
            gui = new JRadioButton();
            gui.setLayout(new GridBagLayout());
            guic = new GridBagConstraints();
            guic.gridx = 0;
            guic.gridy = 0;
            guic.weightx = 0.1;
            guic.weighty = 1.0;
            guic.insets = new Insets(2, 25, 2, 0);
            guic.anchor = 17;
            guic.fill = 2;
            gui.add((Component)new JLabel(JOINCONSTRAINTASKCOL), guic);
            gui.setToolTipText(JOINCONSTRAINTASKCOLTIP);
            this.otherJoin = gui;
            radioGroup2.add(gui);
            ++guic.gridx;
            guic.insets = new Insets(2, 5, 2, 0);
            guic.weightx = 0.99;
            Vector<TapTableColumn> model = new Vector<TapTableColumn>();
            model.addAll(mainColumns);
            this.targetCols = new JComboBox(model);
            this.targetCols.setRenderer(new CustomListCellRenderer());
            this.unrelJoinOperators = new JComboBox<String>(joinOperators);
            TapTableColumn selectedTargetCol = (TapTableColumn)this.targetCols.getSelectedItem();
            Vector<TapTableColumn> sameTypeColumns = this.getSameTypeColumns(selectedTargetCol, joinColumns);
            this.refCols = !model.isEmpty() ? new JComboBox<TapTableColumn>(sameTypeColumns) : new JComboBox();
            this.refCols.setRenderer(new CustomListCellRenderer());
            this.noTypeFilter = new JCheckBox(JOINCOLFILTERLABEL);
            this.noTypeFilter.setToolTipText(JOINCOLFILTERTOOLTIP);
            this.noTypeFilter.setSelected(false);
            this.noTypeFilter.addItemListener(this);
            this.noTypeFilter.setMargin(new Insets(0, 0, 0, 0));
            this.noTypeFilter.setBorderPainted(false);
            this.noTypeFilter.setContentAreaFilled(false);
            this.targetCols.addItemListener(this);
            JPanel unrelatedJoinConstraintPanel = new JPanel();
            unrelatedJoinConstraintPanel.setLayout(new BoxLayout(unrelatedJoinConstraintPanel, 0));
            unrelatedJoinConstraintPanel.setBackground(Aladin.COLOR_CONTROL_BACKGROUND);
            unrelatedJoinConstraintPanel.add(this.targetCols);
            unrelatedJoinConstraintPanel.add(this.unrelJoinOperators);
            unrelatedJoinConstraintPanel.add(this.refCols);
            unrelatedJoinConstraintPanel.add(this.noTypeFilter);
            gui.add((Component)unrelatedJoinConstraintPanel, guic);
            this.setFormState(joinConditions, serverJoinTable);
            joinConstraintsPanel.add(gui);
            ++c.gridy;
            c.anchor = 18;
            c.fill = 0;
            c.insets = new Insets(2, 10, 2, 10);
            this.add((Component)joinConstraintsPanel, c);
            JPanel actionPanel = new JPanel();
            actionPanel.setLayout(new BoxLayout(actionPanel, 0));
            JButton writeJoinButton = new JButton(WRITEJOINBUTTONLABEL);
            writeJoinButton.setActionCommand("ADDWHERECONSTRAINT");
            actionPanel.add(writeJoinButton);
            writeJoinButton.addActionListener(this);
            this.addOrReplace = new JCheckBox(JOINADDORREPLACELABEL);
            this.addOrReplace.setToolTipText(JOINADDORREPLACETOOLTIP);
            this.addOrReplace.setSelected(true);
            actionPanel.add(this.addOrReplace);
            ++c.gridy;
            this.add((Component)actionPanel, c);
            this.constraintListPanel = new JPanel();
            this.constraintListPanel.setLayout(new BoxLayout(this.constraintListPanel, 1));
            this.constraintListPanel.setBorder(BorderFactory.createLineBorder(Aladin.COLOR_BUTTON_BACKGROUND_BORDER_UP));
            JScrollPane constraintsScroller = new JScrollPane(this.constraintListPanel);
            constraintsScroller.getVerticalScrollBar().setUnitIncrement(5);
            constraintsScroller.setMinimumSize(new Dimension(200, 100));
            ++c.gridy;
            c.fill = 1;
            c.insets = new Insets(2, 10, 10, 10);
            c.weighty = 0.94;
            this.add((Component)constraintsScroller, c);
            if (this.uploadTablesGui != null) {
                if (secondaryTable != null) {
                    this.uploadTablesGui.setSelectedItem(secondaryTable);
                } else {
                    this.uploadTablesGui.setEnabled(false);
                }
            }
        }
    }

    private void setFormState(Vector<ForeignKeyColumn> joinConditions, TapTable joinTableMeta) {
        boolean allowPositionJoin = false;
        boolean allowRefJoin = false;
        if (this.serverTap.getRaColumnName() != null && this.serverTap.getDecColumnName() != null && joinTableMeta != null && joinTableMeta.getRaColumnName(true) != null && joinTableMeta.getDecColumnName(true) != null) {
            allowPositionJoin = true;
        }
        if (joinConditions != null && !joinConditions.isEmpty()) {
            allowRefJoin = true;
        }
        if (allowRefJoin) {
            this.targetRefCols.setEnabled(true);
            this.foreignRelJoin.setEnabled(true);
            this.foreignRelJoin.setSelected(true);
        } else {
            this.targetRefCols.setEnabled(false);
            this.foreignRelJoin.setSelected(false);
            this.foreignRelJoin.setEnabled(false);
        }
        if (allowPositionJoin) {
            if (!allowRefJoin) {
                this.positionJoin.setSelected(true);
            }
            this.radius.setEnabled(true);
            this.positionJoin.setEnabled(true);
            this.positionJoin.setToolTipText(JOINCONSTRAINTASKRADIUSTIP);
        } else {
            this.positionJoin.setSelected(false);
            this.positionJoin.setEnabled(false);
            this.radius.setEnabled(false);
            this.positionJoin.setToolTipText(null);
        }
        if (!allowRefJoin && !allowPositionJoin) {
            this.otherJoin.setSelected(true);
        }
        if (this.refCols.getItemCount() == 0) {
            this.refCols.setEnabled(false);
        } else {
            this.refCols.setEnabled(true);
        }
    }

    private Vector<ForeignKeyColumn> getJoinRefConditions(TapTable mainTableMeta) {
        Vector<ForeignKeyColumn> foreignRels = new Vector<ForeignKeyColumn>();
        if (mainTableMeta.foreignKeyColumns != null && !mainTableMeta.foreignKeyColumns.isEmpty()) {
            for (ForeignKeyColumn keyColumn : mainTableMeta.foreignKeyColumns) {
                if (!this.joinTableName.equalsIgnoreCase(keyColumn.getFrom_table())) continue;
                foreignRels.addElement(keyColumn);
            }
        }
        return foreignRels;
    }

    public void addConstraint() throws Exception {
        Map<String, TapTable> uploadedTables;
        StringBuffer cond = new StringBuffer();
        TapTable secTableMetaData = this.serverTap.tapClient.tablesMetaData.get(this.joinTableName);
        if (this.radio2 != null && this.radio2.isSelected() && (uploadedTables = this.serverTap.tapClient.tapManager.getUploadedTables()) != null) {
            secTableMetaData = uploadedTables.get(this.joinTableName);
        }
        String priTableNameForQuery = TapTable.getQueryPart(this.mainTable, true);
        JoinConstraint constraint = new JoinConstraint(this, this.mainTable, secTableMetaData);
        if (this.foreignRelJoin.isSelected()) {
            ForeignKeyColumn forRel = (ForeignKeyColumn)this.targetRefCols.getSelectedItem();
            cond.append(priTableNameForQuery).append(".").append(forRel.getTarget_column()).append(" ").append(" = ").append(constraint.alias).append(".").append(forRel.getFrom_column());
        } else if (this.positionJoin.isSelected()) {
            double radiusInput = 0.0;
            if (this.radius.getText().trim().isEmpty()) {
                throw new Exception(ERROR_NOJOINRADUIS);
            }
            radiusInput = Server.getAngleInArcmin(this.radius.getText(), 1);
            String secRaColumnName = null;
            String secDecColumnName = null;
            if (secTableMetaData != null) {
                secRaColumnName = constraint.raColumnName;
                secDecColumnName = constraint.decColumnName;
            }
            String priRaColumnName = TapTable.getQueryPart(this.serverTap.getRaColumnName(), false);
            String priDecColumnName = TapTable.getQueryPart(this.serverTap.getDecColumnName(), false);
            cond.append("1 =CONTAINS (POINT('ICRS', ").append(priTableNameForQuery).append(".").append(priRaColumnName).append(", ").append(priTableNameForQuery).append(".").append(priDecColumnName).append("), CIRCLE('ICRS', ").append(constraint.alias).append(".").append(secRaColumnName).append(", ").append(constraint.alias).append(".").append(secDecColumnName).append(", ").append(radiusInput).append("/3600.))");
        } else {
            if (!this.refCols.isEnabled()) {
                throw new Exception(ERROR_NOJOINCOLUMN);
            }
            TapTableColumn secColumn = (TapTableColumn)this.refCols.getSelectedItem();
            String mainColName = ((TapTableColumn)this.targetCols.getSelectedItem()).getColumn_name();
            cond.append(priTableNameForQuery).append(".").append(mainColName).append(" ").append(this.unrelJoinOperators.getSelectedItem()).append(constraint.alias).append(".").append(secColumn.getColumn_name());
        }
        if (!cond.toString().isEmpty()) {
            constraint.setConstraintAndGui(cond.toString());
            this.constraints.add(constraint);
            constraint.setMaximumSize(new Dimension(Integer.MAX_VALUE, constraint.getMinimumSize().height));
            constraint.setAlignmentX(0.0f);
            this.constraintListPanel.add(constraint);
        }
        this.addConstraintIntimation();
    }

    private void addConstraintIntimation() {
        if (JOINCONSTRAINTADDEDNOTIFICATION == null || JOINCONSTRAINTADDEDNOTIFICATION.isEmpty()) {
            JOINCONSTRAINTADDEDNOTIFICATION = "Main tap form is now updated with the new join condition. You can verify and submit the updated query.";
        }
        String message = "<html><p style=\"word-wrap: break-word; width: 300px\">" + JOINCONSTRAINTADDEDNOTIFICATION + "</p></html>";
        TapManager.getInstance(this.aladin).eraseNotification(this.info1, message, this.CLIENTINSTR);
        Container frame = SwingUtilities.getAncestorOfClass(JFrame.class, this.serverTap);
        if (frame != null) {
            ((JFrame)frame).toFront();
        }
    }

    @Override
    public void checkSelectionChanged(JComboBox<String> comboBox) {
        if (comboBox.getSelectedItem() != null) {
            String chosen = comboBox.getSelectedItem().toString();
            if (comboBox.equals(this.serverTablesGui) && !chosen.equalsIgnoreCase(this.joinTableName)) {
                Aladin.trace(3, "Change table selection from within the document");
                this.joinTableName = chosen;
                if (!this.radio1.isSelected()) {
                    this.radio1.setSelected(true);
                }
                this.changeTableSelection(this.joinTableName, true);
            } else if (this.uploadTablesGui != null && comboBox.equals(this.uploadTablesGui) && !chosen.equalsIgnoreCase(this.joinTableName)) {
                Aladin.trace(3, "Change table selection from within the document");
                boolean isServerJoin = false;
                if (this.uploadTablesGui.getItemCount() > 0) {
                    this.setUploadState(true);
                    if (this.radio2 != null && this.radio2.isSelected()) {
                        this.joinTableName = chosen;
                    } else {
                        isServerJoin = true;
                    }
                    if (this.uploadTablesGui.getSelectedItem() != null) {
                        String uploadTable = (String)this.uploadTablesGui.getSelectedItem();
                        UploadTablesRenderer uploadTableRenderer = (UploadTablesRenderer)this.uploadTablesGui.getRenderer();
                        String planeName = uploadTableRenderer.getUploadPlaneName(uploadTable);
                        this.uploadTablesGui.setToolTipText(UploadTablesRenderer.getToolTip(planeName, uploadTable));
                    }
                } else {
                    if (this.radio2 != null && this.radio2.isSelected()) {
                        this.joinTableName = (String)this.serverTablesGui.getSelectedItem();
                        this.radio1.setSelected(true);
                    }
                    this.setUploadState(false);
                    isServerJoin = true;
                }
                this.changeTableSelection(this.joinTableName, isServerJoin);
            }
        } else if (this.uploadTablesGui != null && comboBox.equals(this.uploadTablesGui)) {
            this.joinTableName = (String)this.serverTablesGui.getSelectedItem();
            this.radio1.setSelected(true);
            this.setUploadState(false);
            this.changeTableSelection(this.joinTableName, true);
        }
    }

    public void changeTableSelection(String tableChoice, boolean isServerJoin) {
        TapTable mainTableMeta = this.serverTap.tapClient.tablesMetaData.get(this.mainTable);
        TapTable table = null;
        Vector<TapTableColumn> columnNames = null;
        if (isServerJoin) {
            Map<String, TapTable> tablesMetaData = this.serverTap.tapClient.tablesMetaData;
            columnNames = this.serverTap.getColumnsToLoad(tableChoice, tablesMetaData);
            table = tablesMetaData.get(tableChoice);
        } else {
            Map<String, TapTable> uploadedTables = this.serverTap.tapClient.tapManager.getUploadedTables();
            if (uploadedTables != null && uploadedTables.containsKey(tableChoice)) {
                table = uploadedTables.get(tableChoice);
                columnNames = table.getColumns();
            }
        }
        this.refCols.removeAllItems();
        DefaultComboBoxModel<Object> model = null;
        if (columnNames != null && !columnNames.isEmpty()) {
            TapTableColumn selectedTargetCol = (TapTableColumn)this.targetCols.getSelectedItem();
            Vector<TapTableColumn> columns = this.getSameTypeColumns(selectedTargetCol, columnNames);
            model = new DefaultComboBoxModel<TapTableColumn>(columns);
            this.refCols.setModel(model);
        }
        this.targetRefCols.removeAllItems();
        Vector<ForeignKeyColumn> joinConditions = null;
        if (isServerJoin && (joinConditions = this.getJoinRefConditions(mainTableMeta)) != null && !joinConditions.isEmpty()) {
            model = new DefaultComboBoxModel<ForeignKeyColumn>(joinConditions);
            this.targetRefCols.setModel(model);
        }
        this.setFormState(joinConditions, table);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.noTypeFilter) || !this.noTypeFilter.isSelected()) {
            Map<String, TapTable> uploadedTables;
            TapTable secTableMetaData = this.serverTap.tapClient.tablesMetaData.get(this.joinTableName);
            if (this.radio2 != null && this.radio2.isSelected() && (uploadedTables = this.serverTap.tapClient.tapManager.getUploadedTables()) != null) {
                secTableMetaData = uploadedTables.get(this.joinTableName);
            }
            TapTableColumn selectedTargetCol = (TapTableColumn)this.targetCols.getSelectedItem();
            Vector<TapTableColumn> sameTypeColumns = this.getSameTypeColumns(selectedTargetCol, secTableMetaData.getColumns());
            this.refCols.removeAllItems();
            if (!sameTypeColumns.isEmpty()) {
                this.refCols.setEnabled(true);
                DefaultComboBoxModel<TapTableColumn> model = new DefaultComboBoxModel<TapTableColumn>(sameTypeColumns);
                this.refCols.setModel(model);
            } else {
                this.refCols.setEnabled(false);
            }
        }
    }

    public void setUploadState(boolean enabled) {
        if (this.radio2 != null && this.uploadTablesGui != null) {
            this.uploadTablesGui.setEnabled(enabled);
            this.radio2.setEnabled(enabled);
            Component[] component = this.uploadTablesGui.getParent().getComponents();
            for (int i = 0; i < component.length; ++i) {
                if (!"TABLESLABEL".equals(component[i].getName())) continue;
                if (enabled) {
                    component[i].setForeground(SystemColor.textText);
                } else {
                    component[i].setForeground(SystemColor.textInactiveText);
                }
                component[i].setEnabled(enabled);
                break;
            }
        }
    }

    @Override
    public Vector<String> getMatches(String mask, JComboBox<String> comboBox) {
        return this.serverTap.getMatches(mask, comboBox);
    }

    public void showLoadingError() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        GridBagConstraints c = new GridBagConstraints();
        JPanel containerPanel = new JPanel(new GridBagLayout());
        this.CLIENTINSTR = ERROR_NOINTERFACEMESSAGE + " " + this.serverTap.tapClient.tapLabel;
        this.info1.setText(this.CLIENTINSTR);
        c.anchor = 11;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.02;
        this.info1.setHorizontalAlignment(0);
        containerPanel.add((Component)this.info1, c);
        this.add(containerPanel);
        this.revalidate();
        this.repaint();
    }

    public void showloading() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        GridBagConstraints c = new GridBagConstraints();
        JPanel containerPanel = new JPanel(new GridBagLayout());
        this.CLIENTINSTR = LOADING_JOININTERFACEMESSAGE + " " + this.serverTap.tapClient.tapLabel + "...";
        this.info1.setText(this.CLIENTINSTR);
        c.anchor = 11;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.02;
        this.info1.setHorizontalAlignment(0);
        containerPanel.add((Component)this.info1, c);
        this.add(containerPanel);
        this.revalidate();
        this.repaint();
    }

    public void removeAllConstraints() {
        this.constraints.clear();
        this.constraintListPanel.removeAll();
    }

    public void removeConstraint(JoinConstraint constraint) {
        this.constraints.remove(constraint);
        this.constraintListPanel.remove(constraint);
    }

    public Vector<TapTableColumn> getSameTypeColumns(TapTableColumn ref, Vector<TapTableColumn> availableColumns) {
        Vector<TapTableColumn> result = new Vector<TapTableColumn>();
        if (!(this.noTypeFilter != null && this.noTypeFilter.isSelected() || ref == null)) {
            for (TapTableColumn tapTableColumn : availableColumns) {
                if (tapTableColumn.getDatatype() == null) {
                    result.addElement(tapTableColumn);
                    continue;
                }
                if (ref.isNumeric()) {
                    if (!tapTableColumn.isNumeric()) continue;
                    result.addElement(tapTableColumn);
                    continue;
                }
                if (tapTableColumn.isNumeric()) continue;
                result.addElement(tapTableColumn);
            }
        } else {
            result.addAll(availableColumns);
        }
        return result;
    }

    public void updatePositionParams() {
        if (this.radio1.isSelected()) {
            TapTable joinTableMeta = this.serverTap.tapClient.tablesMetaData.get(this.joinTableName);
            if (this.serverTap.getRaColumnName() != null && this.serverTap.getDecColumnName() != null && joinTableMeta != null && joinTableMeta.getRaColumnName(false) != null && joinTableMeta.getDecColumnName(false) != null) {
                this.positionJoin.setEnabled(true);
            } else {
                this.positionJoin.setEnabled(false);
            }
            this.positionJoin.revalidate();
            this.positionJoin.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton button = (JButton)e.getSource();
            String action = button.getActionCommand();
            if (action.equals("ADDWHERECONSTRAINT")) {
                try {
                    if (this.addOrReplace.isSelected()) {
                        this.removeAllConstraints();
                    }
                    this.addConstraint();
                    this.constraintListPanel.revalidate();
                    this.constraintListPanel.repaint();
                    this.serverTap.joinConstraintUpdated();
                }
                catch (Exception e1) {
                    Aladin.trace(3, e1.getMessage());
                    Aladin.error(this.getRootPane(), e1.getMessage());
                }
            } else if (action.equals("REMOVEWHERECONSTRAINT")) {
                JPanel thisComponent = (JPanel)button.getParent();
                if (thisComponent instanceof JoinConstraint) {
                    this.removeConstraint((JoinConstraint)thisComponent);
                }
                this.constraintListPanel.revalidate();
                this.constraintListPanel.repaint();
                this.serverTap.joinConstraintUpdated();
            }
        } else if (e.getSource() instanceof JRadioButton) {
            JRadioButton button = (JRadioButton)e.getSource();
            String action = button.getActionCommand();
            if (action.equals("SERVERJOINTABLESELECTED")) {
                this.checkSelectionChanged(this.serverTablesGui);
            } else if (this.uploadTablesGui != null && action.equals("UPLOADJOINTABLESELECTED")) {
                this.checkSelectionChanged(this.uploadTablesGui);
            }
        }
    }

    public static void showStatusReport() {
        JOptionPane.showMessageDialog(new JFrame(), JOINTIP, "About join form", 1);
    }

    public TapTable getTable(String joinTableName) {
        return this.serverTap.tapClient.tablesMetaData.get(joinTableName);
    }

    static {
        joinOperators = new String[]{"=", "<>"};
        JOINCONTRAINTSTIP = Aladin.chaine.getString("JOINCONTRAINTSTIP");
        JOINCONSTRAINTASKRADIUS = Aladin.chaine.getString("JOINCONSTRAINTASKRADIUS");
        JOINCONSTRAINTASKRADIUSTIP = Aladin.chaine.getString("JOINCONSTRAINTASKRADIUSTIP");
        JOINCONSTRAINTASKCOL = Aladin.chaine.getString("JOINCONSTRAINTASKCOL");
        JOINCONSTRAINTASKCOLTIP = Aladin.chaine.getString("JOINCONSTRAINTASKCOLTIP");
        JOINCONSTRAINTASKEQCOLTIP = Aladin.chaine.getString("JOINCONSTRAINTASKEQCOLTIP");
        GENERCIERROR_JOIN = Aladin.chaine.getString("GENERCIERROR_JOIN");
        ERROR_NOJOINCOLUMNS = Aladin.chaine.getString("ERROR_NOJOINCOLUMNS");
        ERROR_NOJOINRADUIS = Aladin.chaine.getString("ERROR_NOJOINRADUIS");
        JOINFRAMETITLE = Aladin.chaine.getString("JOINFRAMETITLE");
        ERROR_NOINTERFACEMESSAGE = Aladin.chaine.getString("ERROR_NOINTERFACEMESSAGE");
        LOADING_JOININTERFACEMESSAGE = Aladin.chaine.getString("LOADING_JOININTERFACEMESSAGE");
        JOINUPLOADEDTABLETIP = Aladin.chaine.getString("JOINUPLOADEDTABLETIP");
        JOINTABLELABEL = Aladin.chaine.getString("JOINTABLELABEL");
        ERROR_NOJOINCOLUMN = Aladin.chaine.getString("ERROR_NOJOINCOLUMN");
        UPLOADJOINTABLENAMETOOLTIP = Aladin.chaine.getString("UPLOADJOINTABLENAMETOOLTIP");
        WRITEJOINBUTTONLABEL = Aladin.chaine.getString("WRITEJOINBUTTONLABEL");
        JOINUPLOADTABLELABEL = Aladin.chaine.getString("JOINUPLOADTABLELABEL");
        JOINCONSTRAINTADDEDNOTIFICATION = Aladin.chaine.getString("JOINCONSTRAINTADDEDNOTIFICATION");
        JOINTIP = Aladin.chaine.getString("JOINTIP");
        JOINADDORREPLACELABEL = Aladin.chaine.getString("JOINADDORREPLACELABEL");
        JOINADDORREPLACETOOLTIP = Aladin.chaine.getString("JOINADDORREPLACETOOLTIP");
        JOINCOLFILTERLABEL = Aladin.chaine.getString("JOINCOLFILTERLABEL");
        JOINCOLFILTERTOOLTIP = Aladin.chaine.getString("JOINCOLFILTERTOOLTIP");
    }
}

